#include "GetPoint.js"
#include "GetObject.js"

function SetPlaneOrigin( plane )
{
	var origin = plane.projectz( moi.view.getCPlane().origin );
	return moi.vectorMath.createFrame( origin, plane.xaxis, plane.yaxis );
}

function DoDimAngle()
{
	var pointpicker = moi.ui.createPointPicker();

	var projecttocplane = false;
	try {
		projecttocplane = moi.command.getOption( 'DimProjectToCPlane', true );
		moi.ui.commandUI.ProjectToCPlane.value = projecttocplane;
	} catch(e) {}

	if ( projecttocplane )
		pointpicker.projectToCPlane = true;

	var factory = moi.command.createFactory( 'dimangle' );
	var fromlines = false;

	moi.ui.bindUIToInput( 'AnnotationPreset', 'value', factory.getInput(4) );

    while ( 1 )
    {
        if ( !pointpicker.waitForEvent() )
            return;
			
        if ( pointpicker.event == 'finished' )
            break;

        if ( pointpicker.event == 'FromLines' )
        {
			fromlines = true;

			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'CenterPtPrompt' );
			moi.ui.hideUI( 'FromLines' );
			moi.ui.hideUI( 'ProjectToCPlane' );
			moi.ui.showUI( 'SelectFirstLinePrompt' );
			moi.ui.endUIUpdate();

            var objectpicker = moi.ui.createObjectPicker();
            objectpicker.allowCurves();

			while ( 1 )
			{
				if ( !GetObject( objectpicker ) )
            		return;

				if ( factory.initFirstLine( objectpicker.objects.item(0) ) )
					break;
			}

			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'SelectFirstLinePrompt' );
			moi.ui.showUI( 'SelectSecondLinePrompt' );
			moi.ui.endUIUpdate();

			while ( 1 )
			{
	            if ( !GetObject( objectpicker ) )
		            return;

	            if ( factory.initSecondLine( objectpicker.objects.item(0), projecttocplane ) )
					break;
			}

			break;
        }
        else if ( pointpicker.event == 'ProjectToCPlane' )
        {
        	projecttocplane = moi.ui.commandUI.ProjectToCPlane.value;
        	pointpicker.projectToCPlane = projecttocplane;
        }
	}

    pointpicker.projectToCPlane = false;
	pointpicker.disableVerticalStraightSnap = true;

	if ( !fromlines )
	{
		moi.ui.beginUIUpdate();
		moi.ui.hideUI( 'CenterPtPrompt' );
		moi.ui.hideUI( 'FromLines' );
		moi.ui.hideUI( 'ProjectToCPlane' );
		moi.ui.showUI( 'FirstPtPrompt' );
		moi.ui.endUIUpdate();

		factory.setInput( 0, pointpicker.ptframe );
		pointpicker.bindResultPt( factory.getInput(1) );

		if ( projecttocplane )
		{
			pointpicker.restrictToPlane( SetPlaneOrigin(factory.getInput(0).getValue()), true );
		}
		else
		{
			pointpicker.restrictToPlaneThroughPt( factory.getInput(0).getValue().origin, false );
			pointpicker.bindResultOrientation( factory.getInput(0) );
		}

		pointpicker.setBasePt( factory.getInput(0).getValue().origin );
		if ( !GetPoint( pointpicker ) )
			return;

		moi.ui.beginUIUpdate();
		moi.ui.hideUI( 'FirstPtPrompt' );
		moi.ui.showUI( 'SecondPtPrompt' );
		moi.ui.showUI( 'AngleOptions' );
		moi.ui.endUIUpdate();

		pointpicker.clearBindings();
		pointpicker.bindResultPt( factory.getInput(2) );
		moi.ui.commandUI.g_Factory = factory;
		pointpicker.bindFuncPostUpdate( moi.ui.commandUI.OnPoint );
	    pointpicker.restrictToPlane( SetPlaneOrigin(factory.getInput(0).getValue()), true );
	    pointpicker.setBasePt( factory.getInput(0).getValue().origin );

	    while ( 1 )
	    {
	    	if ( !pointpicker.waitForEvent() )
	    		return false;
			
	    	if ( pointpicker.event == 'finished' )
	    		break;

	    	if ( pointpicker.event == 'Angle' )
	    	{
	    		factory.angle = moi.ui.commandUI.Angle.value;
	    		factory.update();
	    		break;
			}
	    }
	}

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SecondPtPrompt' );
	moi.ui.hideUI( 'AngleOptions' );
	moi.ui.hideUI( 'SelectSecondLinePrompt' );
	moi.ui.showUI( 'LocPtPrompt' );
	moi.ui.endUIUpdate();

	pointpicker.clearBindings();
	pointpicker.bindResultPt( factory.getInput(3) );
    pointpicker.restrictToPlane( SetPlaneOrigin(factory.getInput(0).getValue()), true );
	pointpicker.setBasePt( factory.getInput(0).getValue().origin );
	if ( !GetPoint( pointpicker ) )
		return;

	factory.commit();
	
	moi.command.setOption( 'DimProjectToCPlane', projecttocplane, true );
}

DoDimAngle();
